#ifndef GSTVersion_h__
#define GSTVersion_h__

#include <buildspec.h>
#include <string>

#include <boost/shared_ptr.hpp>

namespace GST
{
namespace Utils
{

class GST_API_EXPORT GSTVersion
{
public:
	int major, minor, patch;
	GSTVersion();
	explicit GSTVersion(const std::string &versionString);
	GSTVersion(int maj, int min, int pa);
	bool operator<(const GSTVersion &rhs) const;
	bool operator<=(const GSTVersion &rhs) const;
	bool operator>(const GSTVersion &rhs) const;
	bool operator>=(const GSTVersion &rhs) const;
	bool operator==(const GSTVersion &rhs) const;
	bool operator!=(const GSTVersion &rhs) const;
	bool operator!() const;
	std::string toString() const;

private:
	int compare(const GSTVersion &rhs) const;
};
typedef boost::shared_ptr<GSTVersion> GSTVersionPtr;

#define CURRENT_CLIENT_VERSION \
	GST::Utils::GSTVersion(    \
		CLIENT_VERSION_MAJOR, CLIENT_VERSION_MINOR, CLIENT_VERSION_PATCH)
#define CLIENT_COMPATIBLE_STORAGE_MINVERSION                           \
	GST::Utils::GSTVersion(CLIENT_COMPATIBLE_STORAGE_MINVERSION_MAJOR, \
						   CLIENT_COMPATIBLE_STORAGE_MINVERSION_MINOR, \
						   CLIENT_COMPATIBLE_STORAGE_MINVERSION_PATCH)
#define CLIENT_COMPATIBLE_STORAGE_MAXVERSION                           \
	GST::Utils::GSTVersion(CLIENT_COMPATIBLE_STORAGE_MAXVERSION_MAJOR, \
						   CLIENT_COMPATIBLE_STORAGE_MAXVERSION_MINOR, \
						   CLIENT_COMPATIBLE_STORAGE_MAXVERSION_PATCH)
#define STORAGE_VERSION     \
	GST::Utils::GSTVersion( \
		STORAGE_VERSION_MAJOR, STORAGE_VERSION_MINOR, STORAGE_VERSION_PATCH)
#define STORAGE_COMPATIBLE_CLIENT_MINVERSION                           \
	GST::Utils::GSTVersion(STORAGE_COMPATIBLE_CLIENT_MINVERSION_MAJOR, \
						   STORAGE_COMPATIBLE_CLIENT_MINVERSION_MINOR, \
						   STORAGE_COMPATIBLE_CLIENT_MINVERSION_PATCH)
#define STORAGE_COMPATIBLE_CLIENT_MAXVERSION                           \
	GST::Utils::GSTVersion(STORAGE_COMPATIBLE_CLIENT_MAXVERSION_MAJOR, \
						   STORAGE_COMPATIBLE_CLIENT_MAXVERSION_MINOR, \
						   STORAGE_COMPATIBLE_CLIENT_MAXVERSION_PATCH)

} // namespace Utils
} // namespace GST
#endif // GSTVersion_h__
